function [sigcv,n1cv,n2cv,n3cv] = critcv3(x,p1,p2,p3,d,r1,r2)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.2
% file: critcv3.m
% coded by Dong Li
%
% This function gives the sum of squares of the cross-validation criteria.
% INPUT:
% x = the time series
% p1 = AR order of first regime
% p2 = AR order of second regime
% p3 = AR order of third  regime
%
% d  = delay parameter
% r1 = first threshold
% r2 =  second   ,,
%
% OUTPUT:
% sigcv = Value (1/n)*sum(a.^2), where "a" is the vector with the
%         predictive residuals of the cross-validation.
% n1cv  = Number of data in the first regime
% n2cv  = Number of data in the second regime
% n3cv  =      ,,               third   ,,
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = length(x);
h = max([p d]) + 1;
ecv = zeros(1,n);

Y1 = [];
X1 = [];
Y2 = [];
X2 = [];
Y3 = [];
X3 = [];
n1cv = 0;
n2cv = 0;
n3cv = 0;

for i = h : n
    if x(i - d) <= r1
       n1cv = n1cv + 1;
       Y1 = [Y1;x(i)];
       X1 = [X1;[1 x((i-1):-1:(i-p1))]];
    else
    if (x(i-d) > r1 && x(i-d) < r2)
       n2cv = n2cv + 1;
       Y2   = [Y2;x(i)];
       X2   = [X2;[1 x((i-1):-1:(i-p2))]];
       else
         n3cv = n3cv + 1;
         Y3   = [Y3;x(i)];
         X3   = [X3;[1 x((i-1):-1:(i-p3))]];    
      end;
   end;
end;

i1 = 1 : n1cv;
i2 = 1 : n2cv;
i3 = 1 : n3cv;

for j = 1 : n1cv
    aux    = inv(X1(i1~=j,:)' * X1(i1~=j,:)) * X1(i1~=j,:)' * Y1(i1~=j);
    xpre   = X1(j,:) * aux;
    ecv(j) = Y1(j) - xpre;
end;

for j = 1 : n2cv
    aux  = inv(X2(i2~=j,:)' * X2(i2~=j,:)) * X2(i2~=j,:)' * Y2(i2~=j,:);
    xpre = X2(j,:) * aux;
    ecv(n1cv+j) = Y2(j) - xpre;
end;

for j = 1 : n3cv
    aux = inv(X3(i3~=j,:)' * X3(i3~=j,:)) * X3(i3~=j,:)' * Y3(i3~=j,:);
    xpre = X3(j,:) * aux;
    ecv(n2cv+j) = Y3(j) - xpre;
end;
sigcv = sum(ecv.^2)/n;
